/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.listener.axis.rm;

import filenet.vw.base.logging.Logger;
import filenet.ws.listener.axis.rm.WSRMUtils;
import filenet.ws.listener.utils.WSListenerProperties;
import java.util.Iterator;
import java.util.List;
import javax.xml.soap.SOAPEnvelope;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.addressing.Action;
import org.apache.axis.message.addressing.AddressingHeaders;
import org.apache.axis.message.addressing.MessageID;
import org.apache.axis.message.addressing.RelatesTo;
import org.apache.sandesha.RMMessageContext;
import org.apache.sandesha.storage.CallbackData;
import org.apache.sandesha.ws.rm.RMHeaders;

public class WSRMCallbackData
extends CallbackData {
    public static final String RM_ACTION_PREFIX = "fn:rmAction:";
    protected static Logger logger = Logger.getLogger("filenet.ws.listener.axis.rm");
    protected static final String m_className = "WSRMCallbackData";
    protected static int SYNC_TIMEOUT = 300000;
    protected static boolean SYNC_TIMEOUT_SET = false;
    private String m_relatesToMsgId = null;
    private String m_rmAction = null;
    private boolean m_bIncoming = false;
    private String m_cpName = null;
    private String m_fullPath = null;

    public static String _get_FILE_DATE() {
        return "$Date:   02 Oct 2008 10:25:02  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.6  $";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WSRMCallbackData getOutgoingCallbackData(RMMessageContext rmMessageContext) {
        String method = "getOutgoingCallbackData";
        logger.entering(m_className, method);
        WSRMCallbackData callbackData = null;
        try {
            int msgType = -1;
            String msgId = null;
            String seqId = null;
            String relatesToMsgId = null;
            String rmAction = null;
            String[] cpInfo = null;
            RMHeaders rmHeaders = null;
            AddressingHeaders addressingHeaders = null;
            if (rmMessageContext != null) {
                Message respMsg;
                int start;
                String action;
                WSListenerProperties props = WSRMUtils.getWSListenerProperties(rmMessageContext.getMsgContext());
                cpInfo = WSRMUtils.retrieveCPInfo(props);
                WSRMCallbackData.getSyncTimeOut(rmMessageContext.getMsgContext());
                rmHeaders = rmMessageContext.getRMHeaders();
                addressingHeaders = WSRMCallbackData.getAddressingHeaders(rmMessageContext);
                MessageID messageID = addressingHeaders.getMessageID();
                if (messageID != null) {
                    msgId = messageID.toString();
                }
                if (msgId == null) {
                    msgId = rmMessageContext.getMessageID();
                }
                msgType = rmMessageContext.getMessageType();
                if (addressingHeaders != null) {
                    Action action2;
                    RelatesTo relatesTo = null;
                    List relatesToList = addressingHeaders.getRelatesTo();
                    if (relatesToList != null && !relatesToList.isEmpty() && (relatesTo = (RelatesTo)relatesToList.get(0)) != null) {
                        relatesToMsgId = relatesTo.getURI().toString();
                    }
                    if (msgType == 0 && (action2 = addressingHeaders.getAction()) != null) {
                        String msgTypeString = action2.toString();
                        if (msgTypeString != null) {
                            if (msgTypeString.equals("http://schemas.xmlsoap.org/ws/2005/02/rm/CreateSequence")) {
                                msgType = 1;
                            } else if (msgTypeString.equals("http://schemas.xmlsoap.org/ws/2005/02/rm/CreateSequenceResponse")) {
                                msgType = 2;
                            } else if (msgTypeString.equals("http://schemas.xmlsoap.org/ws/2005/02/rm/TerminateSequence")) {
                                msgType = 6;
                            } else if (msgTypeString.equals("http://schemas.xmlsoap.org/ws/2005/02/rm/SequenceAcknowledgement")) {
                                msgType = 6;
                            }
                        } else {
                            msgType = relatesToMsgId != null ? 3 : 4;
                        }
                    }
                }
                if ((seqId = rmMessageContext.getSequenceID()) == null && rmHeaders != null) {
                    if (rmHeaders.getCreateSequenceResponse() != null) {
                        seqId = rmHeaders.getCreateSequenceResponse().getIdentifier().toString();
                        if (msgType == 0) {
                            msgType = 2;
                        }
                    } else if (rmHeaders.getSequenceAcknowledgement() != null) {
                        seqId = rmHeaders.getCreateSequenceResponse().getIdentifier().toString();
                        if (msgType == 0) {
                            msgType = 2;
                        }
                    } else if (rmHeaders.getTerminateSequence() != null) {
                        seqId = rmHeaders.getTerminateSequence().getIdentifier().toString();
                        if (msgType == 0) {
                            msgType = 6;
                        }
                    }
                }
                if (msgType == 3 && (action = rmMessageContext.getAction()) != null && action.length() > 0 && (start = action.lastIndexOf(RM_ACTION_PREFIX)) != -1) {
                    rmAction = action.substring(start + RM_ACTION_PREFIX.length());
                    rmAction = rmAction.trim();
                }
                if (seqId == null && msgType == 2 && (respMsg = rmMessageContext.getMsgContext().getResponseMessage()) != null) {
                    if (logger.isFinest()) {
                        logger.finest(m_className, method, "Create Message Response outgoing message = " + respMsg.getSOAPPartAsString());
                    }
                    Iterator iterator = respMsg.getSOAPBody().getChildElements();
                    SOAPBodyElement bodyElement = null;
                    while (iterator.hasNext()) {
                        bodyElement = (SOAPBodyElement)iterator.next();
                        if (!bodyElement.getName().equals("CreateSequenceResponse")) continue;
                        Iterator it = bodyElement.getChildElements();
                        while (it.hasNext()) {
                            MessageElement childElement = (MessageElement)it.next();
                            if (!childElement.getName().equals("Identifier")) continue;
                            seqId = childElement.getValue();
                            if (!logger.isFinest()) continue;
                            logger.finest(m_className, method, "SeqId = " + seqId);
                        }
                    }
                }
                callbackData = new WSRMCallbackData();
                callbackData.setIncoming(false);
                if (relatesToMsgId != null) {
                    callbackData.setRelatesToMsgId(relatesToMsgId);
                }
                callbackData.setAction(rmMessageContext.getAction());
                callbackData.setMessageType(msgType);
                callbackData.setMessageNumber(rmMessageContext.getMsgNumber());
                callbackData.setMessageId(msgId);
                callbackData.setSequenceId(seqId);
                if (cpInfo != null) {
                    if (cpInfo.length > 0) {
                        callbackData.setCPName(cpInfo[0]);
                    }
                    if (cpInfo.length > 1) {
                        callbackData.setFullPath(cpInfo[1]);
                    }
                }
                if (rmAction != null) {
                    callbackData.setRMAction(rmAction);
                }
            }
            WSRMCallbackData wSRMCallbackData = callbackData;
            return wSRMCallbackData;
        }
        catch (Exception ex) {
            logger.throwing(m_className, method, ex);
            WSRMCallbackData wSRMCallbackData = callbackData;
            return wSRMCallbackData;
        }
        finally {
            logger.exiting(m_className, method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WSRMCallbackData getIncomingCallbackData(RMMessageContext rmMessageContext) {
        String method = "getIncomingCallbackData";
        logger.entering(m_className, method);
        WSRMCallbackData callbackData = null;
        try {
            int msgType = -1;
            String msgId = null;
            String seqId = null;
            String relatesToMsgId = null;
            String rmAction = null;
            String[] cpInfo = null;
            RMHeaders rmHeaders = null;
            AddressingHeaders addressingHeaders = null;
            if (rmMessageContext != null) {
                rmHeaders = rmMessageContext.getRMHeaders();
                addressingHeaders = rmMessageContext.getAddressingHeaders();
                MessageID messageID = addressingHeaders.getMessageID();
                if (messageID != null) {
                    msgId = messageID.toString();
                }
                if (msgId == null) {
                    msgId = rmMessageContext.getMessageID();
                }
                msgType = rmMessageContext.getMessageType();
                if (addressingHeaders != null) {
                    Action action;
                    RelatesTo relatesTo = null;
                    List relatesToList = addressingHeaders.getRelatesTo();
                    if (relatesToList != null && !relatesToList.isEmpty() && (relatesTo = (RelatesTo)relatesToList.get(0)) != null) {
                        relatesToMsgId = relatesTo.getURI().toString();
                    }
                    if (msgType == 0 && (action = addressingHeaders.getAction()) != null) {
                        String msgTypeString = action.toString();
                        if (msgTypeString != null) {
                            if (msgTypeString.equals("http://schemas.xmlsoap.org/ws/2005/02/rm/CreateSequence")) {
                                msgType = 1;
                            } else if (msgTypeString.equals("http://schemas.xmlsoap.org/ws/2005/02/rm/CreateSequenceResponse")) {
                                msgType = 2;
                            } else if (msgTypeString.equals("http://schemas.xmlsoap.org/ws/2005/02/rm/TerminateSequence")) {
                                msgType = 6;
                            } else if (msgTypeString.equals("http://schemas.xmlsoap.org/ws/2005/02/rm/SequenceAcknowledgement")) {
                                msgType = 5;
                            }
                        }
                        if (msgType == 0) {
                            msgType = relatesToMsgId != null ? 4 : 3;
                        }
                    }
                }
                if ((seqId = rmMessageContext.getSequenceID()) == null && rmHeaders != null) {
                    if (rmHeaders.getCreateSequenceResponse() != null) {
                        seqId = rmHeaders.getCreateSequenceResponse().getIdentifier().toString();
                        if (msgType == 0) {
                            msgType = 2;
                        }
                    } else if (rmHeaders.getSequenceAcknowledgement() != null) {
                        seqId = rmHeaders.getSequenceAcknowledgement().getIdentifier().toString();
                        if (msgType == 0) {
                            msgType = 5;
                        }
                    } else if (rmHeaders.getTerminateSequence() != null) {
                        seqId = rmHeaders.getTerminateSequence().getIdentifier().toString();
                        if (msgType == 0) {
                            msgType = 6;
                        }
                    }
                }
                callbackData = new WSRMCallbackData();
                callbackData.setIncoming(true);
                if (relatesToMsgId != null) {
                    callbackData.setRelatesToMsgId(relatesToMsgId);
                }
                callbackData.setAction(rmMessageContext.getAction());
                callbackData.setMessageType(msgType);
                callbackData.setMessageNumber(rmMessageContext.getMsgNumber());
                callbackData.setMessageId(msgId);
                callbackData.setSequenceId(seqId);
                if (rmAction != null) {
                    callbackData.setRMAction(rmAction);
                }
                MessageContext msgContext = rmMessageContext.getMsgContext();
                WSRMCallbackData.getSyncTimeOut(msgContext);
                WSListenerProperties props = WSRMUtils.getWSListenerProperties(rmMessageContext.getMsgContext());
                cpInfo = WSRMUtils.retrieveCPInfo(props);
                if (cpInfo != null) {
                    if (cpInfo.length > 0) {
                        callbackData.setCPName(cpInfo[0]);
                    }
                    if (cpInfo.length > 1) {
                        callbackData.setFullPath(cpInfo[1]);
                    }
                }
                if (msgContext != null) {
                    msgContext.setProperty("MC.P8BPM.RM.CALLBACK.DATA", (Object)callbackData);
                }
            }
            WSRMCallbackData wSRMCallbackData = callbackData;
            return wSRMCallbackData;
        }
        catch (Exception ex) {
            logger.throwing(m_className, method, ex);
            WSRMCallbackData wSRMCallbackData = callbackData;
            return wSRMCallbackData;
        }
        finally {
            logger.exiting(m_className, method);
        }
    }

    public void setRelatesToMsgId(String relatesToMsgId) {
        this.m_relatesToMsgId = relatesToMsgId;
    }

    public String getRelatesToMsgId() {
        return this.m_relatesToMsgId;
    }

    public void setRMAction(String rmAction) {
        this.m_rmAction = rmAction;
    }

    public String getRMAction() {
        return this.m_rmAction;
    }

    public String getCPName() {
        return this.m_cpName;
    }

    public void setCPName(String cpName) {
        this.m_cpName = cpName;
    }

    public String getFullPath() {
        return this.m_fullPath;
    }

    public void setFullPath(String fullPath) {
        this.m_fullPath = fullPath;
    }

    public void setIncoming(boolean bIncoming) {
        this.m_bIncoming = bIncoming;
    }

    public boolean getIncoming() {
        return this.m_bIncoming;
    }

    private static AddressingHeaders getAddressingHeaders(RMMessageContext rmMessageContext) {
        MessageContext msgContext = null;
        Message msg = null;
        org.apache.axis.message.SOAPEnvelope env = null;
        AddressingHeaders addressingHeaders = null;
        if (rmMessageContext != null) {
            try {
                msgContext = rmMessageContext.getMsgContext();
                if (msgContext != null && (msg = msgContext.getRequestMessage()) != null && (env = msg.getSOAPEnvelope()) != null) {
                    addressingHeaders = new AddressingHeaders((SOAPEnvelope)env);
                }
            }
            catch (AxisFault ex) {
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (addressingHeaders == null) {
                addressingHeaders = rmMessageContext.getAddressingHeaders();
            }
        }
        return addressingHeaders;
    }

    private static void getSyncTimeOut(MessageContext msgContext) {
        if (!SYNC_TIMEOUT_SET) {
            try {
                String s;
                WSListenerProperties props = (WSListenerProperties)msgContext.getProperty("MC.P8BPM.LISTENERPROPERTIES");
                if (props != null && (s = props.getProperty("synchronous.timeout")) != null) {
                    int val = Integer.parseInt(s);
                    SYNC_TIMEOUT = val * 1000;
                    SYNC_TIMEOUT_SET = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

